WITH base AS (
    SELECT
        gu.users_id,
        replace(regexp_substr(d.email, '.*/'), '/', '') AS email,
        REPLACE(regexp_substr(d.email, '/.*'), '/', '') AS ip,
        d.context,
        d.timestamp,
        replace(regexp_substr(d.context, '/[0-9]+\.[0-9]+\.[0-9]+/'), '/', '') AS versao,
        regexp_substr(d.context, '[^/]+$') AS arquivo,
        CASE
            WHEN d.context LIKE '%pgsys%' THEN 'pgsys'
            WHEN d.context LIKE '%tdp%'   THEN 'tdp'
        END AS curso
    FROM nexus.downloads d
    LEFT JOIN glpidb.glpi_useremails gu
           ON gu.email = replace(regexp_substr(d.email, '.*/'), '/', '')
    WHERE regexp_substr(d.email, '/.*') IS NOT NULL AND d.context not LIKE '%/components/%' AND d.context not LIKE '%/repos/%' AND d.context not LIKE '%/utils/%'
),
agrupado AS (
    SELECT
        users_id,
        email,
        MAX(ip) AS ip,
        -- pega versão mais recente do pgsys
        (SELECT b.versao
         FROM base b
         WHERE b.users_id = d.users_id
           AND b.email = d.email
           AND b.curso = 'pgsys'
         ORDER BY b.timestamp DESC
         LIMIT 1) AS versao_pgsys,
        (SELECT MAX(b.timestamp)
         FROM base b
         WHERE b.users_id = d.users_id
           AND b.email = d.email
           AND b.curso = 'pgsys') AS timestamp_pgsys,
        STRING_AGG(d.context, ', ' ORDER BY d.context) AS context,
        STRING_AGG(DISTINCT d.arquivo, ', ' ORDER BY d.arquivo) AS arquivos_baixados,
        STRING_AGG(DISTINCT curso, ', ') AS cursos
    FROM base d
    WHERE d.curso = 'pgsys'
    GROUP BY users_id, email
)
SELECT
    users_id,
    email,
    ip,
    versao_pgsys,
    timestamp_pgsys,
    context,
    cursos,
    arquivos_baixados,
    CASE
        WHEN versao_pgsys BETWEEN '2.2.2' AND '2.2.3'
             AND context LIKE '%pgsmart%'
        THEN true
        WHEN versao_pgsys BETWEEN '2.3.0' AND '2.3.4'
             AND context LIKE '%pgsmart%'
        THEN true
        WHEN versao_pgsys BETWEEN '3.0.0' AND '3.1.1'
             AND context LIKE '%pgsmart-agent%'
             AND context LIKE '%pgsmart-client%'
        THEN true
        WHEN versao_pgsys = '4.0.0'
             AND context LIKE '%pgsmart-agent%'
             AND context LIKE '%pgsmart-client%'
             AND context LIKE '%pgsmart-web%'
        THEN true
        ELSE false
    END AS download_completo
FROM agrupado;