WITH base AS (
    SELECT
        gu.users_id,
        replace(regexp_substr(d.email, '.*/'), '/', '') AS email,
        REPLACE(regexp_substr(d.email, '/.*'), '/', '') AS ip,
        d.context,
        d.timestamp,
        replace(regexp_substr(d.context, '/[0-9]+\.[0-9]+\.[0-9]+/'), '/', '') AS versao,
        regexp_substr(d.context, '[^/]+$') AS arquivo,
        CASE
            WHEN d.context LIKE '%pgsys%' THEN 'pgsys'
            WHEN d.context LIKE '%tdp%'   THEN 'tdp'
        END AS curso
    FROM nexus.downloads d
    LEFT JOIN glpidb.glpi_useremails gu
           ON gu.email = replace(regexp_substr(d.email, '.*/'), '/', '')
    WHERE regexp_substr(d.email, '/.*') IS NOT null
),
agrupado AS (
    SELECT
        users_id,
        email,
        MAX(ip) AS ip,
        (SELECT b.versao
         FROM base b
         WHERE b.users_id = d.users_id
           AND b.email = d.email
           AND b.curso = 'tdp'
         ORDER BY b.timestamp DESC
         LIMIT 1) AS versao_tdp,
        (SELECT MAX(b.timestamp)
         FROM base b
         WHERE b.users_id = d.users_id
           AND b.email = d.email
           AND b.curso = 'tdp') AS timestamp_tdp,
        STRING_AGG(d.context, ', ' ORDER BY d.context) AS context,
        STRING_AGG(DISTINCT d.arquivo, ', ' ORDER BY d.arquivo) AS arquivos_baixados,
        STRING_AGG(DISTINCT curso, ', ') AS cursos
    FROM base d
    WHERE d.curso = 'tdp'
    GROUP BY users_id, email
)
SELECT
    users_id,
    email,
    ip,
    versao_tdp,
    timestamp_tdp,
    context,
    cursos,
    arquivos_baixados,
    CASE
        WHEN context LIKE '%tdp-components%'
         AND context LIKE '%tdp-installer%'
         AND context LIKE '%tdp-utils%'
        THEN true
        ELSE false
    END AS tdp_completo
FROM agrupado;
