#  Downloads do Nexus – PGSYS & TDP

Este repositório tem como objetivo centralizar as consultas e documentações referentes aos **downloads realizados pelos usuários** no [Nexus Repository da Tecnisys](https://repo.tecnisys.com.br/).

---

## Objetivo

* A partir da base de dados **Superset**, no schema `nexus` e na tabela `downloads`, iremos identificar os eventos de download realizados por usuários.
* Com base nesses eventos, iremos popular as tabelas `downloads_postgresys` e `downloads_tdp` do banco de dados `superset`, dentro do schema `superset_consolidado`.
* Definir critérios claros do que será considerado **download completo** para cada plataforma.


---

##  Critérios de Download Completo

### Para o **PGSYS**

Será considerado **download completo** quando o usuário realizar o download de todos os artefatos obrigatórios da plataforma **PGSYS**, que incluem (dependendo da versão):

* **Versões 2.2.2 a 2.2.3**
  * `pgsmart.rpm` 
  
* **Versões 2.3.0 a 2.3.4**
  * `pgsmart.rpm` 

* **Versões 3.0.0 a 3.1.1**
  * `pgsmart-agent.rpm` 
  * `pgsmart-client.rpm` 

* **Versões 4.0.0**
  * `pgsmart-agent.rpm` 
  * `pgsmart-client.rpm`
  * `pgsmart-web.rpm`

### Para o **TDP**

Será considerado **download completo** quando o usuário realizar o download de todos os componentes essenciais da **Tecnisys Data Platform**, que incluem (dependendo da versão):

* **Versões 2.2.2 a 2.3.0**

  * `tdp-core`
  * `tdp-ingestion`
  * `tdp-processing`
  * `tdp-analytics`
  * Pacotes auxiliares/documentação

---

##  Estrutura do Repositório

```
.
├── README.md                                                   # Documentação principal
└── consultas/                                                  # Scripts e consultas para checar os downloads
    ├── [consulta_antiga.md](./consultas/consulta_antiga.sql)   # Primeira consulta feita por Felipe e Talles
    └── [consultas_1.0.md](./consultas/consulta_1.0.md)         # Refatorada por Milena
```

---
| Versão | Data       | Autor            | Alterações                                                                                              |
| ------ | ---------- | ---------------- | ------------------------------------------------------------------------------------------------------- |
| 1.0  | 09/09/2025 | Milena Rcoha | Criação inicial do repositório e definição dos critérios de download completo para **PGSYS** e **TDP**. |

