#  Downloads do Nexus – PGSYS & TDP

Este repositório tem como objetivo centralizar as consultas e documentações referentes aos **downloads realizados pelos usuários** no [Nexus Repository da Tecnisys](https://repo.tecnisys.com.br/).

---

## Objetivo

* A partir da base de dados **Superset**, no schema `nexus` e na tabela `downloads`, iremos identificar os eventos de download realizados por usuários.
* Com base nesses eventos, iremos popular as tabelas `downloads_postgresys` e `downloads_tdp` do banco de dados `superset`, dentro do schema `superset_consolidado`.
* Definir critérios claros do que será considerado **download completo** para cada plataforma.


---

##  Critérios de Download Completo

### Para o **PGSYS**

Será considerado **download completo** quando o usuário realizar o download de todos os artefatos obrigatórios da plataforma **PGSYS**, que incluem (dependendo da versão):

* **Versões 2.2.2 a 2.2.3**
  * `pgsmart.rpm` 
  
* **Versões 2.3.0 a 2.3.4**
  * `pgsmart.rpm` 

* **Versões 3.0.0 a 3.1.1**
  * `pgsmart-agent.rpm` 
  * `pgsmart-client.rpm` 

* **Versões 4.0.0**
  * `pgsmart-agent.rpm` 
  * `pgsmart-client.rpm`
  * `pgsmart-web.rpm`

> Esta consulta retorna informações detalhadas sobre os downloads relacionados ao curso **pgsys**, com foco em identificar se os usuários baixaram o conjunto completo de ferramentas.

| Coluna | Descrição | Tipo de Dado |
| :--- | :--- | :--- |
| `users_id` | Identificador do usuário no sistema GLPI. | `INT` |
| `email` | E-mail do usuário associado aos downloads. | `VARCHAR(255)` |
| `ip` | Último endereço IP utilizado pelo usuário para download. | `VARCHAR(255)` |
| `versao_pgsys` | Versão mais recente do `pgsys` baixada pelo usuário. | `VARCHAR(6)` |
| `timestamp_pgsys` | Carimbo de data/hora do download mais recente do `pgsys`. | `TIMESTAMP` |
| `context` | Lista concatenada de todos os caminhos de download (`context`) do usuário, ordenados. | `TEXT` |
| `cursos` | Lista de cursos (`pgsys` ou `tdp`) associados aos downloads do usuário. | `VARCHAR(10)` |
| `arquivos_baixados` | Lista concatenada e única dos nomes dos arquivos baixados. | `TEXT` |
| `download_completo` | Indica se o usuário baixou a suite completa de ferramentas do `pgsys` para a versão mais recente. | `BOOLEAN` |

---


### Para o **TDP**

Será considerado **download completo** quando o usuário realizar o download de todos os componentes essenciais da **Tecnisys Data Platform**, que incluem:

*   **Para o TDP (Plataforma de Desenvolvimento Tecnológico) Local**: O usuário precisa ter baixado os três tipos de arquivos a seguir:
    1.  Um arquivo `installer-rhel-7.sh(1°)` .
    2.  Um arquivo `utils-2-1-0-rhel-7-x86-64.tar.gz(1°)`    .
    3.  Pelo menos um dos `components-2-1-0-rhel-7-x86-64.tar.gz(1°)` disponíveis .

*   **Para o TDP (Plataforma de Desenvolvimento Tecnológico) Online/Nexus**: O usuário precisa ter baixado os três tipos de arquivos a seguir:
    1.  Um arquivo `installer-rhel-7.sh(1°)` .
    2.  Um arquivo `ambari-server-3.0.0.3-0.x86_64.rpm(2°)`.

> Esta consulta foca nos downloads do curso **tdp**, verificando se os usuários baixaram a suite completa de componentes, instalador e utilitários.

| Coluna | Descrição | Tipo de Dado |
| :--- | :--- | :--- |
| `users_id` | Identificador do usuário no sistema GLPI. | `INT` |
| `email` | E-mail do usuário associado aos downloads. | `VARCHAR(255)` |
| `ip` | Último endereço IP utilizado pelo usuário para download. | `VARCHAR(255)` |
| `versao_tdp` | Versão mais recente do `tdp` baixada pelo usuário. | `VARCHAR(6)` |
| `timestamp_tdp` | Carimbo de data/hora do download mais recente do `tdp`. | `TIMESTAMP` |
| `context` | Lista concatenada de todos os caminhos de download (`context`) do usuário, ordenados. | `TEXT` |
| `cursos` | Lista de cursos (`pgsys` ou `tdp`) associados aos downloads do usuário. | `VARCHAR(10)` |
| `arquivos_baixados` | Lista concatenada e única dos nomes dos arquivos baixados. | `TEXT` |
| `download_completo` | Indica se o usuário baixou os componentes essenciais (`tdp-components`, `tdp-installer`, `tdp-utils`). | `BOOLEAN` |

> Vale ressaltar que os downloads locais não estão sendo considerados

---

##  Estrutura do Repositório

```
.
├── README.md                                                  # Documentação principal
└── ddl                                                        # DDL de criação das tabelas
    ├── [ddl_pgsys.sql](./ddl/ddl_pgsys.sql)      
    └── [ddl_tdp.sql](./ddl/ddl_tdp.sql)         
└── consultas/                                                  # Scripts e consultas para checar os downloads
    ├── [consulta_antiga.sql](./consultas/consulta_antiga.sql)   # Primeira consulta feita por Felipe e Talles
    ├── [pgsys_download.sql](./consultas/pgsys_download.sql)      # Refatorada por Milena
    └── [tdp_downlaods.sql](./consultas/tdp_download.sql)         # Refatorada por Milena
```

---
| Versão | Data       | Autor            | Alterações                                                                                              |
| ------ | ---------- | ---------------- | ------------------------------------------------------------------------------------------------------- |
| 1.0  | 09/09/2025 | Milena Rcoha | Criação inicial do repositório e definição dos critérios de download completo para **PGSYS** e **TDP**. |

